import React from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import cx from 'classnames';
import css from './IssueDone.module.css';

interface Props {
  onClick: () => void;
  value?: boolean;
  disabled?: boolean;
}

const IssueDone: React.FC<Props> = ({ onClick, value, disabled }) => (
  <Button
    className={!value && !disabled ? css.button_state_false : undefined}
    view={value ? 'action' : 'pseudo'}
    size="xs"
    pin="circle-circle"
    onClick={onClick}
    disabled={disabled}
    icon={(cls) => (
      <Icon
        className={cx(cls, css.icon)}
        svg={!disabled || value ? 'check' : 'empty'}
        svgSize="s"
      />
    )}
  />
);

export default IssueDone;
