import React, { useCallback, useContext } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import Icon from 'lego/components/Icon';
import { IssueIdContext } from '../../Issue/IssueIdContext';

export interface UnlinkData {
  issueId: number;
  targetId: number;
  linkRole: 0;
}

export interface Props {
  onClick: (e: React.MouseEvent<HTMLButtonElement, MouseEvent>, value: UnlinkData) => void;
  disabled?: boolean;
  issueId: number;
}

const renderIconLink = (iconCls) => (
  <Icon className={iconCls} pack={Icon.PACKS.MATERIAL} icon="link" />
);

const IssueUnlink: React.FC<Props> = ({ onClick, disabled, issueId }) => {
  const parentId = useContext(IssueIdContext);

  const handleClick = useCallback(
    (e) => {
      onClick(e, {
        issueId: parentId,
        targetId: issueId,
        linkRole: 0,
      });
    },
    [issueId, onClick, parentId],
  );

  return (
    <Button
      view="clear"
      size="xs"
      onClick={handleClick}
      disabled={disabled}
      title="Отвязать"
      icon={renderIconLink}
    />
  );
};

export default IssueUnlink;
