import Bluebird from 'bluebird';
import { IssueFieldSchemeProps } from 'modules/issues/types';
import { WithOId } from 'types';

export enum EditType {
  Inline = 1,
  Popup,
  Modal,
  Custom,
}

export enum FieldEditType {
  TextInput = EditType.Inline,
  WFInput = EditType.Inline,
  SuggestStaffInline2 = EditType.Popup,
  Date = EditType.Popup,
  IssueDone = EditType.Custom,
  IssueUnlink = EditType.Custom,
  AccountModal = EditType.Modal,
  Timers = EditType.Custom,
  SupportChat = EditType.Custom,
  SupportChatIssue = EditType.Custom,
  Button = EditType.Custom,
  Button2 = EditType.Custom,
  ButtonGroup = EditType.Custom,
  DropdownMenu = EditType.Custom,
  IssueTags = EditType.Custom,
  IssueFastTags = EditType.Custom,
  Tip = EditType.Custom,
}

export const SubmitValueMapper = {
  adapters: {
    SuggestStaffInline2: (value) => (value || {}).id,
    AccountModal: (value) => value.id,
    default: (value) => value,
  },
  get(type) {
    return this.adapters[type] || this.adapters.default;
  },
};

export interface SubmitOptions {
  name?: string;
  redirect?: boolean;
  url?: string;
}

export interface SubmitData {
  name: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
  options: SubmitOptions;
}

export interface FieldProps extends IssueFieldSchemeProps, WithOId {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onSubmit: (data: SubmitData) => Bluebird<any>;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
  issueId: number;
  redirect?: () => void;
}

export interface FieldBaseProps extends IssueFieldSchemeProps, WithOId {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onSubmit?: (value: any, options?: SubmitOptions) => Bluebird<any>;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onClear?: () => Bluebird<any>;
  isLoading?: boolean;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
  issueId: number;
  redirect?: () => void;
}
