import React, { HTMLAttributes } from 'react';
import cx from 'classnames';
import css from './IssueFieldLayout.module.css';
import EventFromField from '../utils/EventFromField';

export interface Props {
  label?: React.ReactNode;
  width?: string;
  className?: string;
  size?: string;
  color?: string;
  weight?: string;
  stopPropagation?: boolean;
  onClick?: HTMLAttributes<HTMLDivElement>['onClick'];
}

const IssueFieldLayout: React.FC<Props> = ({
  label,
  children,
  width,
  className,
  size,
  color,
  weight,
  stopPropagation,
  onClick,
}) => (
  <div
    className={cx(
      css.b,
      css[`b_width_${width}`],
      css[`b_size_${size}`],
      css[`b_color_${color}`],
      css[`b_weight_${weight}`],
      className,
    )}
    onClick={onClick}
  >
    {label && (
      <div className={css.b__labelWrap}>
        <span className={css.b__label}>{label}</span>
      </div>
    )}
    <div className={css.b__field} {...(stopPropagation ? EventFromField.props : null)}>
      {children}
    </div>
  </div>
);

export default IssueFieldLayout;
