import * as React from 'react';
import cx from 'classnames';
import css from './History.module.css';

interface Props {
  issueId: number;
  className?: string;
}

const History = (props: Props) => {
  return (
    <iframe
      src={`${window.CRM_SPACE_API_HOST}/issue/history/get?issueId=${props.issueId}`}
      title="История задача"
      className={cx(props.className, css.b)}
      data-testid="history-action-tab/iframe"
    />
  );
};

export default History;
