import React, { useEffect } from 'react';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import IssueListView from './IssueListView';
import { Props } from './types';

interface ConnectedDispatch {
  get: () => void;
  destroy: () => void;
}

const IssueList = (props: Props & ConnectedDispatch) => {
  const { destroyOnUnmount, get, destroy, hash, ...other } = props;

  useEffect(() => {
    if (hash) {
      get();
    }

    return () => {
      if (destroyOnUnmount) {
        destroy();
      }
    };
  }, [hash]);

  return <IssueListView hash={hash} {...other} />;
};

export default withReduxContext<Props>(
  connect<null, ConnectedDispatch, Props & InjectedReduxContextProps>(null, (dispatch, props) => ({
    get: () => {
      const extension = props.getLoadParamExtension || props.getParamExtension;

      dispatch(props.redux.slices.nodesSlice.asyncActions.get(extension()));
    },
    ...bindActionCreators({ destroy: props.redux.slices.moduleSlice.actions.destroy }, dispatch),
  }))(IssueList),
);
