import React from 'react';
import Access from 'utils/Access';
import IssueTreeNode from '../Issue/IssueTreeNode';
import IssueItem from './IssueItem';
import CreateNewIssue from '../CreateNewIssue';
import css from './IssueList.scss';
import storagePathCreator from '../../utils/storagePathCreator';
import { Props } from './types';

const IssueListView = (props: Props) => {
  const {
    hash,
    hasInfiniteScroll,
    getParamExtension,
    getLoadParamExtension,
    getSubmitParamExtension,
    component,
    showNewIssueForm,
    maxAccess,
    path,
  } = props;

  let showNewIssueFormFormatted = showNewIssueForm;
  if (showNewIssueFormFormatted && Number.isInteger(maxAccess as number)) {
    showNewIssueFormFormatted = Access.isEdit(maxAccess);
  }

  return (
    <div className={css.b}>
      {showNewIssueFormFormatted && (
        <CreateNewIssue
          key={hash}
          getSubmitParamExtension={getSubmitParamExtension || getParamExtension}
        />
      )}
      <IssueTreeNode
        className={css.b__list}
        id={0}
        path={path || storagePathCreator.data2Path(getParamExtension()) || ''}
        component={component}
        hasInfiniteScroll={hasInfiniteScroll}
        getLoadParamExtension={getLoadParamExtension || getParamExtension}
        wrap="div"
        maxAccess={maxAccess}
      />
    </div>
  );
};

IssueListView.defaultProps = {
  component: IssueItem,
  showNewIssueForm: true,
};

export default IssueListView;
