import React from 'react';
import Search from 'pages/mail/components/Search';
import { connect } from 'react-redux';
import { withReduxContext } from 'modules/issues/redux';

const IssueSearch = props => <Search type="issue" {...props} enableReinitialize />;

export default withReduxContext(
  connect(
    (state, props) => ({
      initialValues: props.redux.selectors.getSearchFilterDataUI(state),
      forceShowAllFilters: props.redux.selectors.getCurrentFilterType(state) === 'search',
      module: props.redux.name,
    }),
    (dispatch, props) => ({
      onCancel: () =>
        dispatch(props.redux.slices.filterSlice.actions.setWithRefresh({ type: 'fast' })),
      onSubmit: (values, valuesUI) =>
        dispatch(
          props.redux.slices.filterSlice.actions.setWithRefresh({
            type: 'search',
            data: { values, valuesUI },
          }),
        ),
    }),
  )(IssueSearch),
);
