import React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import Select from '@crm/components/dist/lego2/Select';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import css from './Issues.module.css';

interface Option {
  value: string;
  content: string;
}

interface ConnectedState {
  sort: string;
  options: Option[];
}

interface ConnectedDispatch {
  onChangeSort: (sort: string) => void;
}

type Props = ConnectedState & ConnectedDispatch;

const IssueSort: React.FC<Props> = (props) => {
  const { sort, onChangeSort, options } = props;

  return (
    <div className={css.b__sort}>
      <Select
        options={options}
        size="xs"
        value={sort}
        hasEmptyValue={false}
        onChange={onChangeSort}
      />
    </div>
  );
};

export default withReduxContext(
  connect<ConnectedState, ConnectedDispatch, InjectedReduxContextProps>(
    (state, props) => ({
      sort: props.redux.selectors.getSearchFilterSort(state),
      options: props.redux.selectors.moduleSettings(state).sortItems,
    }),
    (dispatch, props) =>
      bindActionCreators(
        { onChangeSort: props.redux.slices.filterSlice.actions.setSort },
        dispatch,
      ),
  )(IssueSort),
);
