import React from 'react';
import { Route, RouteComponentProps } from 'react-router-dom';
import IssueMain from './IssueMain';

interface Params {
  id: string;
  timelineId: string;
}

const IssueAdapter: React.FC<RouteComponentProps<Params>> = ({ match, history }) => {
  const id = parseInt(match.params.id, 10);
  const { timelineId } = match.params;
  const redirect = () => {
    let url = '/issues';
    if (history.location.search) {
      url += history.location.search;
    }
    history.replace(url);
  };

  if (!Number.isInteger(id)) {
    return null;
  }

  return <IssueMain id={id} timelineId={timelineId} redirect={redirect} />;
};

interface IssueRouterProps {
  module: string;
}

const IssueRouter: React.FC<IssueRouterProps> = props => (
  <Route path={`/${props.module}/:id/:timelineId?`} component={IssueAdapter} />
);

export default IssueRouter;
