import React, { useContext, useEffect } from 'react';
import { XivaBackendEvents, XivaBackendEventType, XivaContext } from 'modules/xiva';

type IssueModuleRefreshProps = {
  refresh: (data: XivaBackendEvents[XivaBackendEventType.IssueModuleRefresh]) => void;
};

export const IssueModuleRefresh: React.FC<IssueModuleRefreshProps> = ({ refresh }) => {
  const xiva = useContext(XivaContext);

  useEffect(() => {
    xiva.addEventListener(XivaBackendEventType.IssueModuleRefresh, refresh);
    return () => {
      xiva.removeEventListener(XivaBackendEventType.IssueModuleRefresh, refresh);
    };
  }, [refresh, xiva]);

  return null;
};
