import React, { useMemo } from 'react';
import { issueServicesContext } from './issueServicesContext';
import { IssueServicesProviderComponent, IssueServicesContextType } from './types';
import { QueueService } from '../../services/QueueService';
import { CallAvailableServiceImpl } from '../../services/CallAvailableServiceImpl';

export const IssueServicesProvider: IssueServicesProviderComponent = ({ children, issue }) => {
  const queueId = (issue.data.queue && issue.data.queue.id) || 0;
  const issueId = issue.id;

  const queueService = useMemo(() => {
    return new QueueService(queueId);
  }, [queueId]);

  const callAvailableService = useMemo(() => {
    return new CallAvailableServiceImpl(issueId);
  }, [issueId]);

  const services = useMemo<IssueServicesContextType>(() => {
    return {
      callMetaService: queueService,
      callAvailableService,
    };
  }, [queueService, callAvailableService]);

  return <issueServicesContext.Provider value={services}>{children}</issueServicesContext.Provider>;
};
