import React from 'react';
import createLink from 'modules/issues/utils/createLink';
import { Bubble } from 'components/Bubble';
import Link from '@crm/components/dist/lego2/Link';
import { IssueType } from 'modules/issues/types';
import css from './IssueTags.module.css';
import { IssueTagsProps } from './IssueTags.types';

export const IssueTags: React.FC<IssueTagsProps> = ({ issues }) => {
  return (
    <div className={css.IssueTags}>
      {issues.map((issue) => (
        <Bubble key={issue.id}>
          <Link
            target="_blank"
            theme="black"
            href={createLink({ id: issue.id, typeId: IssueType.Opportunities })}
            title={issue.name}
          >
            {issue.name}
          </Link>
        </Bubble>
      ))}
    </div>
  );
};
