import React from 'react';
import Icon from '@crm/components/dist/lego2/Icon';
import ModuleIcon from 'components/ModuleIcon';

interface Props {
  unreadCount?: number;
}

const IssueModuleIcon: React.FC<Props> = ({ unreadCount }) => {
  return (
    <ModuleIcon
      count={unreadCount == null ? 0 : unreadCount}
      icon={(cls) => <Icon svg="issue" svgSize="l" className={cls} />}
    />
  );
};

export default IssueModuleIcon;
