import React, { lazy, Suspense } from 'react';
import { Route, RouteComponentProps } from 'react-router-dom';
import { Modal } from 'modules/timer';
import TitleChain from 'modules/heading';
import { createAuthorizationComponent } from 'modules/authorization/moduleAuthorization';
import { ModuleName, BackendModuleName } from '../types';

const Page = lazy(() => import('./Page'));

const authMap = {
  [ModuleName.Issue]: createAuthorizationComponent('issue'),
  [ModuleName.Ticket]: createAuthorizationComponent('ticket'),
  [ModuleName.Opportunities]: createAuthorizationComponent(BackendModuleName.Opportunities),
};

interface IssueRouterProps extends RouteComponentProps {
  title: string;
  module: ModuleName;
}

const IssueRouter: React.FC<IssueRouterProps> = (props) => {
  const { title, module } = props;

  const Auth = authMap[module];

  return (
    <Auth>
      <Suspense fallback={<span />}>
        <Route
          exact
          path={props.match.path}
          component={(() => <TitleChain>{title}</TitleChain>) as React.FC}
        />
        <Modal.Provider>
          <Page />
        </Modal.Provider>
        <Modal.Modal contentProps={{ module }} />
      </Suspense>
    </Auth>
  );
};

export default IssueRouter;
