import React, { useCallback, CSSProperties } from 'react';
import { Dispatch } from 'redux';
import { connect } from 'react-redux';
import Flex from 'components/Layout/Flex';
import ReactBuilder from 'components/ReactBuilder';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import cx from 'classnames';
import app from 'app';
import schemeStartrekItem from './schemeStartrekItem';
import StartrekPropsContext from './StartrekPropsContext';
import css from '../Issue/IssueItem.module.css';
import StartrekField from './StartrekField';
import EventFromField from '../utils/EventFromField';
import { StartrekObject } from '../../types';
import { SubmitData } from '../IssueField';

const components = {
  IssueField: StartrekField,
  Flex,
};

export interface OwnProps {
  id: number;
  scheme?: any;
  className?: string;
  theme?: string;
  style?: CSSProperties;
  unlink?: (stKey: string) => void;
}

interface ConnectedDispatch {
  dispatch: Dispatch<any>;
}

interface ConnectedState {
  startrek: StartrekObject;
}

const Startrek: React.FC<OwnProps &
  ConnectedDispatch &
  ConnectedState &
  InjectedReduxContextProps> = props => {
  const { startrek, className, scheme = schemeStartrekItem, theme = 'oneline', style } = props;

  if (!startrek) {
    return null;
  }

  const handleSubmitField = useCallback((data: SubmitData) => {
    // нужно подумать как это получше архитектурно сделать
    if (data.name === 'unlinkStartrek' && props.unlink) {
      props.unlink(startrek.data.key);
    }

    return Promise.resolve(true);
  }, []);

  const handleClick = useCallback(e => {
    if (!EventFromField.isPrevent(e.target)) {
      window.open(app.getStartrekLink(startrek.data.key));
    }
  }, []);

  return (
    <StartrekPropsContext.Provider value={{ ...props, onSubmit: handleSubmitField }}>
      <div
        role="presentation"
        tabIndex={-1}
        className={cx(css.b, className)}
        style={style}
        onClick={handleClick}
      >
        <div className={cx(css.b__wrap, css[`b__wrap_theme_${theme}`])}>
          <ReactBuilder components={components} meta={scheme} />
        </div>
      </div>
    </StartrekPropsContext.Provider>
  );
};

export default withReduxContext<OwnProps>(
  connect<ConnectedState, ConnectedDispatch, OwnProps & InjectedReduxContextProps>(
    (state, props) => ({
      startrek: props.redux.selectors.storage.startrekIssues.getItem(state, props.id),
    }),
  )(Startrek),
);
