import React, { useContext } from 'react';
import StartrekPropsContext from './StartrekPropsContext';
import { Field } from '../IssueField';
import getFieldProps from '../utils/getFieldProps';

const StartrekField = props => {
  const startrekProps = useContext(StartrekPropsContext);

  const fieldProps = getFieldProps(
    'Startrek',
    startrekProps.startrek,
    props,
    startrekProps.redirect,
    startrekProps.dispatch,
    startrekProps.maxAccess,
  );

  if (!fieldProps) {
    return null;
  }

  return <Field onSubmit={startrekProps.onSubmit} {...fieldProps} />;
};

export default StartrekField;
