import React from 'react';
import { Dispatch } from 'redux';
import createContextHOC from 'utils/createContextHOC';
import { StartrekObject } from '../../types';

export interface ContextProps {
  startrek: StartrekObject;
  dispatch: Dispatch<any>;
  redirect?: () => void;
  maxAccess?: number;
  more?: React.ReactElement;
  onSubmit: (data: any) => any;
}

export interface InjectedContextProps {
  startrek: ContextProps;
}

const StartrekPropsContext = React.createContext<ContextProps>(Object());

export const withStartrekProps = createContextHOC<ContextProps, InjectedContextProps>({
  Context: StartrekPropsContext,
  propName: 'startrek',
});

export default StartrekPropsContext;
