import { FlexNode } from '../schemes/types';

const scheme: FlexNode = {
  component: 'Flex',
  props: {
    max: true,
    fields: true,
    style: {
      alignItems: 'center',
    },
  },
  content: [
    {
      component: 'IssueField',
      props: {
        access: 3,
        name: 'unlinkStartrek',
        component: 'Button',
        alert: true,
        fieldProps: {
          view: 'clear',
          icon: {
            pack: 'material',
            icon: 'link',
          },
        },
      },
    },
    {
      component: 'IssueField',
      props: {
        size: 'xs',
        color: 'gray',
        name: 'key',
        component: 'TextInput',
        previewComponent: 'TrackerKey',
        access: 1,
      },
    },
    {
      component: 'IssueField',
      props: {
        size: 'xs',
        color: 'gray',
        weight: 'bold',
        name: 'state',
        component: 'TextInput',
        access: 1,
      },
    },
    {
      component: 'IssueField',
      props: {
        width: 'max',
        name: 'title',
        component: 'TextInput',
        access: 1,
      },
    },
    {
      component: 'Flex',
      props: {
        right: true,
        fields: true,
        style: {
          flexShrink: 0,
        },
      },
      content: [
        {
          component: 'IssueField',
          props: {
            stopPropagation: true,
            name: 'createdOn',
            icon: {
              pack: 'fontawesome',
              icon: 'calendar',
            },
            iconWithValue: false,
            component: 'Date',
            access: 1,
            previewComponent: 'PreviewDate',
          },
        },
        {
          component: 'IssueField',
          props: {
            stopPropagation: true,
            name: 'owner',
            backendUpdateKey: 'ownerId',
            component: 'SuggestStaffInline2',
            access: 1,
            previewComponent: 'PreviewStaff',
            fieldProps: {
              isSingleValue: true,
              autoFocus: true,
              view: 'inline',
              hideSuggestIfSingleValue: false,
            },
            previewProps: {
              zIndex: 999,
              theme: 'avatar',
              size: 'xs',
            },
          },
        },
      ],
    },
  ],
};

export default scheme;
