import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import Call from './Call';
import { CallConnectedProps, CallOwnProps } from './Call.types';
import { isTestMode } from '../../../redux/createSelectors';

const mapStateToProps = (state, props) => {
  const data = props.callData || props.redux.selectors.storage.calls.getItem(state, props.id) || {};

  return {
    call: data.data,
    access: props.access || data.props,
    isTest: isTestMode(state),
    categorization: data.categorization,
  };
};

export default withReduxContext(
  connect<CallConnectedProps, {}, CallOwnProps & InjectedReduxContextProps>(mapStateToProps)(Call),
);
