import * as React from 'react';
import { ETypeString } from 'types/entities';
import Icon from 'lego/components/Icon';
import Item from '../Item';
import CallInfo from './CallInfo';
import TogglePreviewButton from '../TogglePreviewButton';
import { CallProps, CallState } from './Call.types';
import { Categorization } from '../Categorization';
import { getColor, getDirectionIcon } from './Call.utils';
import { CallPreview } from './CallPreview';

export default class Call extends React.Component<CallProps, CallState> {
  constructor(props: CallProps) {
    super(props);
    this.state = { isOpen: Boolean(props.isOpen) };
    this.callPreview = this.callPreview.bind(this);
  }

  private toggleFullVersion = () => {
    this.setState((state) => ({ isOpen: !state.isOpen }));
  };

  private callPreview() {
    return (
      <CallPreview
        nodeId={this.props.nodeId}
        redux={this.props.redux}
        isTest={this.props.isTest}
        call={this.props.call}
        issueId={this.props.issueId}
      />
    );
  }
  public render(): React.ReactElement {
    const {
      call,
      access,
      issueId,
      isTest,
      categorization,
      activityData = {},
      ...other
    } = this.props;
    const { isOpen } = this.state;
    const color = getColor(call);
    const { author, dt } = call;
    const isCompleted = call.callStatus.id === 2;
    const callInfoView = call.callStatus.id === 2 && isOpen ? 'full' : 'regular';
    const callDate = new Date(call.dt);
    const description = `${call.direction.name} звонок от ${callDate.toLocaleDateString(
      'ru',
    )}, ${callDate.toLocaleTimeString('ru', {
      hour: '2-digit',
      minute: '2-digit',
    })}`;

    return (
      <Item
        author={author}
        color={color}
        date={dt}
        icon={<Icon pack={Icon.PACKS.MATERIAL} icon="phone" />}
        issueId={issueId}
        side={getDirectionIcon(call.direction.id)}
        afterAuthorName={
          isCompleted && (
            <TogglePreviewButton
              entityName="звонок"
              isOpen={this.state.isOpen}
              toggleAction={this.toggleFullVersion}
            />
          )
        }
        {...other}
      >
        <Categorization
          issueId={issueId}
          name={other.nodeId}
          workplace={ETypeString.YcCall}
          eType={call.eType}
          preview={this.callPreview}
          id={call.id}
          access={access.category}
          isRequireMarkup={access.isRequireMarkup}
          initialValue={categorization}
          targetDescription={description}
        />
        <CallInfo
          isTest={isTest}
          call={call}
          activityData={activityData}
          preview={!isOpen}
          view={callInfoView}
        />
      </Item>
    );
  }
}
