import { Call } from 'types/entities/call';
import { Tag } from 'types/Tag';
import { CategorizationValue } from '../Categorization';
import { Activity } from '../ManagerActivity/ManagerActivity.types';

export interface CallActivityData {
  id?: number;
  showActivityTags?: boolean;
  tags?: Tag[];
}

export interface CallAccessCollection {
  access: number;
  canSelectCategory?: number;
  category: number;
  isRequireMarkup?: number;
}

export interface CallOwnProps {
  redux: {
    name: string;
  };
  issueId: number;
  timelineId?: string;
  nodeId: string;
  access?: CallAccessCollection;
  isOpen?: boolean;
  callData: Activity<Call>;
  activityData?: CallActivityData;
}

export interface CallState {
  isOpen: boolean;
}

export interface CallConnectedProps {
  call: Call;
  access: CallAccessCollection;
  isTest: boolean;
  categorization?: CategorizationValue;
}

export type CallProps = CallOwnProps & CallConnectedProps;
