import React from 'react';
import { types as TimelineItemTypes } from 'components/TimelineItem';
import Icon from 'lego/components/Icon';
import { Call } from './CallInfo/CallInfo.types';

export const getColor = (call: Call): TimelineItemTypes.ColorType => {
  let color: TimelineItemTypes.ColorType = call.direction.id === 1 ? 'red' : 'green';

  if (call.direction.id === 4) {
    color = 'blue';
  }

  if (call.endReason && call.endReason.success === false) {
    color = 'grey';
  }
  return color;
};

export const getDirectionIcon = (id: number) => {
  const direction = id === 1 ? 'arrow_downward' : 'arrow_upward';
  return <Icon pack={Icon.PACKS.MATERIAL} icon={direction} />;
};
