import React, { FC } from 'react';
import { TimelineItemTags } from 'modules/tags';
import css from './ActivityTags.module.css';
import { ActivityTagsProps } from './ActivityTags.types';

export const ActivityTags: FC<ActivityTagsProps> = ({ id, tags }) => {
  return (
    <div className={css.ActivityTags}>
      <TimelineItemTags eType="Activity" name={`'Activity'${id}`} id={id} tags={tags} canEdit />
    </div>
  );
};
