import React, { FC, useContext } from 'react';
import { AudioSource as AudioSourceComponent } from 'components/AudioSource';
import { useGlobalAudioContext } from 'modules/audio';
import { IssueIdContext } from 'modules/issues/components/Issue/IssueIdContext';
import { AudioSourceProps } from './AudioSource.types';

export const AudioSource: FC<AudioSourceProps> = (props) => {
  const issueId = useContext(IssueIdContext);
  const globalAudio = useGlobalAudioContext();

  return (
    <AudioSourceComponent {...props} audio={globalAudio} metaCacheClearKey={issueId.toString()} />
  );
};
