import { Call } from 'types/entities/call';
import { Categorization } from 'types/entities/categorization';
import React from 'react';
import { CallActivityData } from '../Call.types';
export type ListView = 'regular' | 'full' | 'accountHistory' | 'accountHistoryPersonal';

export { Call };

export interface CallInfoProps {
  call: Call;
  preview?: boolean;
  isTest: boolean;
  view: ListView;
  categorization?: Categorization;
  activityData?: CallActivityData;
}

export type GetRecordLink = (call: Call) => React.ReactNode;
export type Field = (string | number)[];
export type FieldsList = Field[];
export { Categorization };
