import React, { PureComponent } from 'react';
import get from 'lodash/get';
import { UpsaleFactorsComponent } from 'components/UpsaleFactors';
import { CallPreviewProps } from './CallPreview.types';
import css from './CallPreview.module.css';
import FieldPlaceholder from '../FieldPlaceholder';
import CONSTANTS from '../CallInfo.constants';

export default class CallPreview extends PureComponent<CallPreviewProps> {
  private getFieldValue = (fieldName: string, propNames: string[]): React.ReactNode => {
    const { call } = this.props;
    const isHidden = Boolean(call.kik && call.kik.hidden);
    if (isHidden) {
      return <FieldPlaceholder fieldName="kikHidden" />;
    }
    let value;
    for (let propName of propNames) {
      value = get(call, propName);
      if (value !== undefined) {
        break;
      }
    }

    return value !== undefined ? value : <FieldPlaceholder fieldName={fieldName} />;
  };

  render() {
    const { call } = this.props;

    return (
      <div data-testid="call-preview">
        <p className={css.b}>
          <span className={css.b__fieldName}>{CONSTANTS.name}:</span>
          <span className={css.b__value}>
            {this.getFieldValue('kikName', ['clientInfo.name', 'kik.name'])}
          </span>
          <span className={css.b__fieldName}>{CONSTANTS.phone}:</span>
          <span className={css.b__value}>
            {this.getFieldValue('kikPhone', ['clientInfo.phone', 'kik.phoneE164'])}
          </span>
        </p>
        <UpsaleFactorsComponent factors={call.upsaleFactors} />
      </div>
    );
  }
}
