import React, { FC } from 'react';
import Icon from 'lego/components/Icon';
import Item from '../../Item';
import CallInfo from '../CallInfo';
import { CallPreviewProps } from './CallPreview.types';
import css from './CallPreview.module.css';
import { getColor, getDirectionIcon } from '../Call.utils';

export const CallPreview: FC<CallPreviewProps> = (props) => {
  const { call, issueId, isTest, ...other } = props;
  const color = getColor(call);
  const { author, dt } = call;
  return (
    <Item
      className={css.CallPreview}
      author={author}
      color={color}
      date={dt}
      icon={<Icon pack={Icon.PACKS.MATERIAL} icon="phone" />}
      issueId={issueId}
      side={getDirectionIcon(call.direction.id)}
      {...other}
    >
      <CallInfo isTest={isTest} call={call} view="full" />
    </Item>
  );
};
