import React, { FC, useMemo } from 'react';
import {
  Categorization as CategorizationBase,
  parseFromBackend,
  CategoriesPreview,
} from 'modules/categorization';
import Access from 'utils/Access';
import get from 'lodash/get';
import { WidgetV3 } from './WidgetV3';
import { CategorizationProps } from './Categorization.types';
import { useCategorizationChange } from './useCategorizationChange';

export const Categorization: FC<CategorizationProps> = (props) => {
  const { issueId, id } = props;

  const onChange = useCategorizationChange({
    issueId,
    eId: id,
    eType: props.eType,
  });

  const { initialValue, access } = props;

  const formattedInitialValue = useMemo(() => parseFromBackend(initialValue), [initialValue]);

  if (Access.isEdit(access)) {
    if (props.issueId && props.eType) {
      return (
        <WidgetV3
          {...props}
          eId={id}
          onChange={onChange}
          initialValue={initialValue}
          issueId={issueId}
        />
      );
    }

    return (
      <CategorizationBase
        {...props}
        onChange={onChange}
        initialValue={formattedInitialValue}
        issueId={issueId}
      />
    );
  }

  if (Access.isRead(access)) {
      const categories = Object.keys(formattedInitialValue.selectedCategories).map(
        (categoryId) => formattedInitialValue.categories[categoryId],
      );
      return <CategoriesPreview categories={categories} />;
  }

  return null;
};
