import React, { FC, useState, useRef } from 'react';
import Tooltip from '@crm/components/dist/lego2/Tooltip';
import { CategoryTagProps } from './CategoryTag.types';
import css from './CategoryTag.module.css';

export const CategoryTag: FC<CategoryTagProps> = ({ children, textAlign }) => {
  const [isTooltipVisible, setTooltipVisible] = useState(false);
  const timerId = useRef<number>();
  const nodeRef = useRef<HTMLDivElement>(null);

  const handleClick = () => {
    setTooltipVisible(true);
  };

  const handleMouseLeave = () => {
    timerId.current = window.setTimeout(() => {
      setTooltipVisible(false);
    }, 200);
  };

  const handleMouseEnter = () => {
    window.clearTimeout(timerId.current);
  };

  return (
    <div
      className={css.CategoryTag}
      role="listitem"
      onClick={handleClick}
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      ref={nodeRef}
      style={{
        textAlign,
      }}
    >
      {children}
      <Tooltip
        anchor={nodeRef}
        visible={isTooltipVisible}
        state="success"
        direction="bottom-center"
        size="s"
        view="default"
        padding="xs"
        hasTail
      >
        <span className={css.CategoryTag__tooltipText}>{children}</span>
      </Tooltip>
    </div>
  );
};
