import React, { FC } from 'react';
import cx from 'classnames';
import { CategoryTag, types } from './CategoryTag';
import { CategoryTagsProps } from './CategoryTags.types';
import css from './CategoryTags.module.css';

export const CategoryTags: FC<CategoryTagsProps> = (props) => {
  const { tags = [] } = props;

  const className = cx(css.CategoryTags, props.className, {
    [css.CategoryTags_view_one]: tags.length === 1,
    [css.CategoryTags_view_two]: tags.length === 2,
    [css.CategoryTags_view_many]: tags.length >= 3,
  });

  let textAlign: types.TextAlign = 'center';
  if (tags.length > 2) {
    textAlign = 'left';
  }

  return (
    <div className={className} role="list">
      {tags.map((text) => (
        <CategoryTag key={text} textAlign={textAlign}>
          {text}
        </CategoryTag>
      ))}
    </div>
  );
};
