import React, { FC } from 'react';
import { Widget } from 'modules/categorization2';
import { normalize } from 'normalizr';
import Access from 'utils/Access';
import Icon from 'lego/components/Icon';
import { WidgetV3Props } from './WidgetV3.types';
import { CategoryTags } from '../CategoryTags';
import css from './WidgetV3.module.css';
import { getInitialCategoryIds } from '../utils';
import { itemSchema } from '../schemas';
import { useCategorizationHandlers } from '../useCategorizationHandlers';

export const WidgetV3: FC<WidgetV3Props> = (props) => {
  const { preview = () => null, eId, issueId, eType } = props;

  const { onChange, initialValue, ...handlers } = useCategorizationHandlers({
    issueId,
    eId,
    eType,
    initialValue: props.initialValue,
  });

  let initialValueToNormalize = {};
  if (initialValue && typeof initialValue === 'object') {
    initialValueToNormalize = initialValue;
  }
  const normalizedInitialValue = normalize(initialValueToNormalize, {
    categories: [itemSchema],
  });
  const tags = getInitialCategoryIds(initialValue).map((id) => {
    const byId = normalizedInitialValue.entities.items;
    if (byId && byId[id]) {
      return byId[id].fullName;
    }
    return String(id);
  });

  return (
    <Widget
      Preview={preview}
      {...handlers}
      onSave={onChange}
      middle={
        Access.isRead(props.isRequireMarkup) &&
        !tags.length && (
          <div className={css.requiredWarning}>
            <Icon pack={Icon.PACKS.MATERIAL} icon="warning" className={css.requiredWarning__icon} />
            требуется разметка
          </div>
        )
      }
      under={
        Array.isArray(tags) &&
        tags.length > 0 && <CategoryTags className={css.b__categoryTags} tags={tags} />
      }
    />
  );
};
