import { schema } from 'normalizr';

export const itemSchema = new schema.Entity(
  'items',
  {},
  {
    processStrategy: (entity, parent) => {
      if (entity && parent) {
        return {
          ...entity,
          parentId: parent.id,
        };
      }

      return entity;
    },
  },
);

itemSchema.define({
  items: [itemSchema],
});

export const rootSchema = new schema.Object({
  items: [itemSchema],
});
