import { useCallback, useContext } from 'react';
import { CategorizationValue, formatToBackend } from 'modules/categorization';
import { ReduxContext } from 'modules/issues/redux';
import { useDispatch } from 'react-redux';

export const useCategorizationChange = ({
  issueId,
  eId,
  eType,
}: {
  issueId: number;
  eId: number;
  eType: string;
}) => {
  const redux = useContext(ReduxContext);
  const dispatch = useDispatch();

  return useCallback(
    (value: CategorizationValue | { id: number }[]) => {
      return dispatch(
        redux.slices.timelineSlice.asyncActions.saveCategory(
          {
            issueId,
            id: eId,
            eType,
            categories: Array.isArray(value) ? value : formatToBackend(value),
          },
          {
            contextExtend: {
              main: {
                issue: {
                  id: issueId,
                },
              },
            },
          },
        ),
      );
    },
    [issueId, eId, eType],
  );
};
