import { CategorizationValue } from 'modules/categorization';
import { types, utils } from 'modules/categorization2';

export const getInitialCategoryIds = (initialValue?: CategorizationValue): number[] => {
  if (!initialValue || !initialValue.selectedCategories || !initialValue.categories) {
    return [];
  }

  const ids = Object.keys(initialValue.selectedCategories);
  let result: number[] = [];

  for (let i = 0, length = ids.length; i < length; i++) {
    const id = ids[i];
    const childIds = Object.keys(initialValue.selectedCategories[id]).map(Number);
    if (childIds.length) {
      result = result.concat(childIds);
      continue;
    }
    result.push(Number(id));
  }

  return result;
};

export const createValueTreeFromIds = (
  root: number[],
  byId: types.ById,
  ids: number[],
): types.ValueAsTreeNode => {
  const tree: types.ValueAsTreeNode = {};

  root.forEach((id) => {
    tree[id] = {};
  });

  const getById = (id: number) => byId[id];

  for (let i = 0; i < ids.length; i++) {
    const id = ids[i];
    const path = utils.getPathFromHighestParent(getById, id);
    let node = tree;

    for (let j = 0; j < path.length; j++) {
      const pathCategoryId = path[j];
      node[pathCategoryId] = {
        ...node[pathCategoryId],
      };
      node = node[pathCategoryId];
    }
  }

  return tree;
};

export const getDeepResults = (input: number[], byId: types.ById): number[] => {
  let results: number[] = [];

  for (let i = 0; i < input.length; i++) {
    const id = input[i];
    const category = byId[id];

    if (Array.isArray(category.items) && category.items.length) {
      results = results.concat(category.items);
      continue;
    }

    results.push(id);
  }

  return results;
};
