import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import {
  ConnectedChatMessageState,
  ConnectedChatMessageDispatch,
  ChatMessageOwnProps,
} from './ChatMessage.types';
import ChatMessageIssue from './ChatMessageIssue';

export default withReduxContext(
  connect<
    ConnectedChatMessageState,
    ConnectedChatMessageDispatch,
    ChatMessageOwnProps & InjectedReduxContextProps
  >(
    (state, props) => {
      const data = props.redux.selectors.storage.messages.getItem(state, props.id) || {};

      return {
        message: data.data,
        access: props.access || data.props,
      };
    },
    (dispatch, props) => ({
      onRemove: () => {
        if (window.confirm('Вы уверены, что хотите удалить этот комментарий?')) {
          dispatch(
            props.redux.slices.timelineSlice.asyncActions.messageDelete({
              messageId: props.id,
              issueId: props.issueId,
            }),
          );
        }
      },
    }),
  )(ChatMessageIssue),
);
