// TODO: https://st.yandex-team.ru/CRM-10202
import * as React from 'react';
import Access from 'utils/Access';
import Comment from 'components/Comment';
import Icon from 'lego/components/Icon';
import Item, { Action } from '../../Item';
import { ChatMessageProps } from './ChatMessageIssue.types';

export const ChatMessageIssue: React.FC<ChatMessageProps> = (props) => {
  const { message, access, onRemove, onEdit, issueId, ...other } = props;
  const { author, createdOn } = message;

  const actions: Action[] = [];

  const edit = (): void => {
    if (typeof onEdit === 'function') {
      onEdit(message);
    }
  };

  if (Access.isEdit(access.access)) {
    actions.push({
      key: 'edit',
      onClick: edit,
      children: 'Редактировать',
    });
  }

  if (Access.isEdit(access.access)) {
    actions.push({
      key: 'remove',
      onClick: onRemove,
      children: 'Удалить',
    });
  }

  return (
    <Item
      author={author}
      actions={actions}
      date={createdOn}
      icon={<Icon pack={Icon.PACKS.MATERIAL} icon="message" />}
      issueId={issueId}
      {...other}
    >
      <Comment comment={{ ...message, isHtml: false }} />
    </Item>
  );
};
