import { ComTypeString } from 'types/ComType';
import { LoadMailData } from '../types';
import { CommunicationTypes } from './Communication.types';

export const CONFIRM_MESSAGE = 'Все несохраненные данные будут потеряны.';

export const TYPE_MAPPER = {
  draft: (mailId: number): LoadMailData => ({ type: 'draft', mailId }),
  reply: (mailId: number): LoadMailData => ({ type: 'reply', replyToMailId: mailId }),
  replyAll: (mailId: number): LoadMailData => ({
    type: 'reply',
    replyToMailId: mailId,
    IsReplyToAll: true,
  }),
  forward: (mailId: number): LoadMailData => ({
    type: 'reply',
    replyToMailId: mailId,
    isForward: true,
  }),
  forwardInternal: (mailId: number): LoadMailData => ({
    type: 'reply',
    replyToMailId: mailId,
    isForward: true,
    isInternalMail: true,
  }),
};

export const COMTYPE_MAPPER = {
  [ComTypeString.None]: CommunicationTypes.Mail,
  [ComTypeString.AllChannels]: CommunicationTypes.Mail,
  [ComTypeString.Mail]: CommunicationTypes.Mail,
  [ComTypeString.InCall]: CommunicationTypes.Mail,
  [ComTypeString.OutCall]: CommunicationTypes.Mail,
  [ComTypeString.Chat]: CommunicationTypes.Message,
};
