import { LoadMailData, Comment, ChatMessage } from '../types';

export enum CommunicationTypes {
  Comment = 'comment',
  Mail = 'mail',
  Message = 'message',
  InternalMessage = 'internalMessage',
}

export interface InputRef {
  reply: (text: string) => void;
}

export interface CommunicationProps {
  issueId: number;
  className?: string;
  showCommentForm?: boolean;
  showMailForm?: boolean;
  showMessageForm?: boolean;
  showInternalMessageForm?: boolean;
  canCommentSendAndOpen?: boolean;
  isPristineCommentForm?: boolean;
  isPristineMailForm?: boolean;
  comType?: string;
}

export interface MailConfig {
  type: string;
  loadArgs: unknown;
  isInternalMail?: boolean;
}

export interface CommunicationState {
  tab: CommunicationTypes | undefined;
  loadMailData: LoadMailData;
  mailKey: number;
  pristine: boolean;
  comment?: Comment;
  message?: ChatMessage;
  internalMessage?: ChatMessage;
}
