// TODO: https://st.yandex-team.ru/CRM-10202
// eslint-disable
// jsx-a11y/click-events-have-key-events,
// jsx-a11y/no-static-element-interactions

import * as React from 'react';
import { history } from 'entry/appHistory';
import { TimelineItem } from 'components/TimelineItem';
import { Props } from './Item.types';
export { Action } from './Item.types';

class Item extends React.Component<Props> {
  private getItemId = (): string => {
    const { nodeId } = this.props;
    if (!nodeId) {
      return '';
    }

    return nodeId.replace(':', '-');
  };

  public render() {
    const { highlight, timelineId, redux, issueId } = this.props;
    const itemId = this.getItemId();

    return (
      <TimelineItem
        dateUrl={`/${redux.name}/${issueId}/${itemId}${history.location.search}`}
        {...this.props}
        author={this.props.author}
        htmlId={itemId}
        highlight={highlight || timelineId === itemId}
      />
    );
  }
}

export default Item;
