import React from 'react';
import Tags from 'pages/mail/components/Tags';
import cx from 'classnames';
import { getTagsName } from 'pages/mail/selectors';
import css from './header.module.css';

export const Header = (args) => {
  const { className, id, files: Files, info: Info, tags, props } = args;

  const tagsName = getTagsName(id);

  return (
    <div className={cx(className, css.root)}>
      <Info />
      <Tags className={css.tags} name={tagsName} id={id} tags={tags} canEdit={!props.readonly} />
      <Files />
    </div>
  );
};
