import * as TYPES from '../types';
type Color = 'grey' | 'orange' | 'red' | 'green';
export const mapColor = ({
  isExternal,
  type,
}: {
  isExternal: boolean;
  type: TYPES.MailType;
}): Color => {
  if (type === 'Draft') {
    return 'grey';
  }

  if (!isExternal) {
    return 'orange';
  }

  if (type === 'Inbox') {
    return 'red';
  }

  if (type === 'Outbox') {
    return 'green';
  }

  return 'grey';
};
