import React, { FC, useEffect, useState } from 'react';
import Icon from 'lego/components/Icon';
import Mail from 'components/Mail';
import Item from '../../Item';
import { MailPreviewProps } from './MailPreview.types';
import css from './MailPreview.module.css';
import { DIRECTION_ICON } from '../Mail.constants';
import { mapColor } from '../Mail.utils';

export const MailPreview: FC<MailPreviewProps> = (props) => {
  const { mail, issueId, ...other } = props;
  const { type, dt, author, isExternal, hasAttach } = mail;
  const [data, setData] = useState<unknown>();
  const [isLoading, setIsLoading] = useState(false);

  useEffect(() => {
    setIsLoading(true);
    props
      .load()
      // @ts-ignore
      .then((data) => {
        if (data) {
          setData(data);
        }
      })
      .finally(() => {
        setIsLoading(false);
      });
    // eslint-disable-next-line
  }, []);

  if (isLoading) {
    return null;
  }

  const color = mapColor({
    isExternal,
    type,
  });

  return (
    <Item
      className={css.MailPreview}
      author={author}
      date={dt}
      color={color}
      dateUrl={undefined}
      icon={<Icon pack={Icon.PACKS.MATERIAL} icon="mail" />}
      side={
        <>
          {DIRECTION_ICON[type]}
          {hasAttach && <Icon pack={Icon.PACKS.MATERIAL} icon="attach_file" />}
        </>
      }
      issueId={issueId}
      {...other}
    >
      <Mail {...data} className={css.b__mail} />
    </Item>
  );
};
