import { connect } from 'react-redux';
import React from 'react';
import { ETypeString } from 'types/entities';
import { Call as CallType } from 'types/entities/call';
import Access from 'utils/Access';
import { InjectedReduxContextProps, withReduxContext } from '../../../redux';
import Call from '../Call';
import {
  Activity,
  ManagerActivityConnectedProps,
  ManagerActivityOwnProps,
  ManagerActivityProps,
} from './ManagerActivity.types';
import { READONLY_YCCALL_ACCESS } from '../TimelineNode';

const ManagerActivity: React.FC<ManagerActivityProps> = (props) => {
  const { activity, isOpen, maxAccess, ...other } = props;
  const activityData = {
    id: activity?.data?.id,
    tags: activity?.data?.tags,
    showActivityTags: props?.redux?.name === 'opportunities',
  };
  const entity = { ...activity, data: activity.data.entityData };

  if (activity.data.entityType === ETypeString.YcCall) {
    const access = !Access.isEdit(maxAccess) ? READONLY_YCCALL_ACCESS : undefined;

    return (
      <Call
        {...other}
        activityData={activityData}
        access={access}
        isOpen={isOpen}
        callData={entity as Activity<CallType>}
      />
    );
  }

  return null;
};

const mapStateToProps = (state, props) => {
  return {
    activity: props.redux.selectors.storage.managerActivities.getItem(state, props.id) || {},
  };
};

export default withReduxContext(
  connect<ManagerActivityConnectedProps, {}, ManagerActivityOwnProps & InjectedReduxContextProps>(
    mapStateToProps,
  )(ManagerActivity),
);
