import { DataObject } from 'types/Attributes';
import { EType } from 'types/EType';
import { Tag } from 'types/Tag';

export interface ManagerActivityOwnProps {
  id: number;
  isOpen?: boolean;
  redux: {
    name: string;
  };
  issueId: number;
  timelineId?: string;
  nodeId: string;
  maxAccess?: number;
}

interface ManagerActivityData<T> {
  id?: number;
  tags?: Tag[];
  entityData: T;
  entityType: EType;
}

export type Activity<T = unknown> = DataObject<ManagerActivityData<T>, unknown, unknown>;

export interface ManagerActivityConnectedProps {
  activity: Activity;
}

export type ManagerActivityProps = ManagerActivityOwnProps & ManagerActivityConnectedProps;
