import React, { FC, ComponentType } from 'react';
import { connect } from 'react-redux';
import { TimelineMeeting } from 'components/TimelineMeeting';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import { MeetingProps, ConnectedState } from './Meeting.types';

const MeetingComponent: FC<MeetingProps> = (props) => {
  const { meeting, ...restProps } = props;

  return <TimelineMeeting {...restProps} meeting={meeting} />;
};

export const Meeting = withReduxContext(
  connect<ConnectedState, unknown, InjectedReduxContextProps & MeetingProps>((state, props) => {
    const data = props.redux.selectors.storage.meetings.getItem(state, props.id) || {};

    return {
      meeting: data.data,
      editAccess: data?.props?.access || 1,
    };
  })(MeetingComponent),
) as ComponentType<Partial<MeetingProps>>;
