// TODO: https://st.yandex-team.ru/CRM-10202
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import Comment from 'forms/Comment/Comment';
import { MessageFormDispatchProps, MessageFormProps } from './MessageForm.types';

export default withReduxContext<MessageFormProps>(
  connect<{}, MessageFormDispatchProps, MessageFormProps & InjectedReduxContextProps>(
    null,
    (dispatch, props) => ({
      onSubmit: (values) =>
        dispatch(
          props.redux.slices.timelineSlice.asyncActions.messageSave({
            issueId: props.issueId,
            messageId: props.objId,
            ...values,
          }),
        ),
    }),
    (stateProps, dispatchProps, ownProps) => ({ ...dispatchProps, ...ownProps }),
  )(Comment),
);
