export class ResolutionSerializer {
  static readonly prefix = 'r:';

  static format(str: string) {
    return `${ResolutionSerializer.prefix}${str}`;
  }

  static parse(str: string) {
    return str.slice(2);
  }

  static isResolution(str: unknown) {
    return typeof str === 'string' && str.startsWith(ResolutionSerializer.prefix);
  }
}
