// TODO: https://st.yandex-team.ru/CRM-10202
import * as React from 'react';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';
import Button from '@crm/components/dist/lego2/Button';
import Icon from '@crm/components/dist/lego2/Icon';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import config from './config';

interface Props {
  setSort: (sort: string) => void;
  sort: string;
}

const Sort = (props: Props) => {
  const { setSort, sort } = props;

  const buttonConfig = config.sortConfig[sort];

  return (
    <Button
      view="clear"
      size="xs"
      onClick={() => setSort(config.sortSwitcher[sort])}
      iconRight={(iconCls) => (
        <Icon className={iconCls} type="arrow" direction={buttonConfig.direction} />
      )}
    >
      {buttonConfig.text}
    </Button>
  );
};

interface ConnectedState {
  sort: string;
}

interface ConnectedDispatch {
  setSort: (sort: string) => void;
}

export default withReduxContext<{}>(
  connect<ConnectedState, ConnectedDispatch, InjectedReduxContextProps>(
    (state, props) => ({
      sort: props.redux.selectors.timeline.sort(state),
    }),
    (dispatch, props) =>
      bindActionCreators(
        { setSort: props.redux.slices.timelineSettingsSlice.actions.setSort },
        dispatch,
      ),
  )(Sort),
);
