// TODO: https://st.yandex-team.ru/CRM-10202
import * as React from 'react';
import { connect } from 'react-redux';
import { withReduxContext, InjectedReduxContextProps } from 'modules/issues/redux';
import Access from 'utils/Access';
import Comment from './Comment';
import { ChatMessage } from './ChatMessage';
import { Mail } from './Mail';
import Call, { CallAccessCollection } from './Call';
import { Meeting } from './Meeting';
import {
  MailProps,
  CommentProps,
  ChatMessageProps,
  Comment as CommentType,
  ChatMessage as ChatMessageType,
} from './types';
import ManagerActivity from './ManagerActivity';

interface Props {
  className?: string;
  node: {
    id: number;
  };
  type: string;
  issueId: number;
  timelineId?: string;
  editComment?: false | ((comment: CommentType) => void);
  editMessage?: false | ((message: ChatMessageType) => void);
  editInternalMessage?: false | ((internalMessage: ChatMessageType) => void);
  replyByComment?: false | ((text: string) => void);
  replyByMail?: false | ((mailId: number, method: string) => void);
  maxAccess?: number;
  access?: CommentProps | ChatMessageProps | MailProps | CallAccessCollection;
  expandItems?: boolean;
  [key: string]: unknown;
}

/* TODO: refactoring maxAccess */
const READONLY_MAIL_ACCESS: MailProps = {
  access: 1,
  canReply: 0,
  canReplyAll: 0,
  canForward: 0,
  canForwardInternal: 0,
  canSend: 0,
  canDetach: 0,
  canCreateTicket: 0,
  canCreateTicketST: 0,
  canPrintAttachments: 0,
  isOpen: 0,
  category: 0,
  isRequireMarkup: 0,
};

const READONLY_COMMENT_ACCESS: CommentProps = {
  access: 1,
  canReply: 0,
  canSendAndOpen: 0,
  isRequireMarkup: 0,
  category: 0,
};

const READONLY_MESSAGE_ACCESS: ChatMessageProps = {
  access: 1,
  isRequireMarkup: 0,
  category: 0,
};

export const READONLY_YCCALL_ACCESS: CallAccessCollection = {
  access: 1,
  canSelectCategory: 0,
  isRequireMarkup: 0,
  category: 0,
};

const TimelineNode: React.FC<Props & ConnectedProps & InjectedReduxContextProps> = (props) => {
  const {
    node,
    type,
    editComment,
    editMessage,
    editInternalMessage,
    replyByComment,
    replyByMail,
    maxAccess,
    expandItems,
    ...other
  } = props;

  if (type === 'ManagerActivity') {
    return <ManagerActivity {...other} id={node.id} isOpen={expandItems} maxAccess={maxAccess} />;
  }

  if (type === 'ChatMessage') {
    if (maxAccess !== undefined && !Access.isEdit(maxAccess)) {
      other.access = READONLY_MESSAGE_ACCESS;
    }

    // @ts-ignore https://st.yandex-team.ru/CRM-10202
    return <ChatMessage {...other} onEdit={editMessage} id={node.id} />;
  }

  if (type === 'InternalChatMessage') {
    if (maxAccess !== undefined && !Access.isEdit(maxAccess)) {
      other.access = READONLY_MESSAGE_ACCESS;
    }

    // @ts-ignore https://st.yandex-team.ru/CRM-10202
    return <ChatMessage {...other} onEdit={editInternalMessage} id={node.id} />;
  }

  if (type === 'OComment') {
    if (maxAccess !== undefined && !Access.isEdit(maxAccess)) {
      other.access = READONLY_COMMENT_ACCESS;
    }

    // @ts-ignore https://st.yandex-team.ru/CRM-10202
    return <Comment {...other} onReply={replyByComment} onEdit={editComment} id={node.id} />;
  }

  if (type === 'Mail') {
    if (maxAccess !== undefined && !Access.isEdit(maxAccess)) {
      other.access = READONLY_MAIL_ACCESS;
    }

    // @ts-ignore https://st.yandex-team.ru/CRM-10202
    return <Mail {...other} isOpen={expandItems} onReply={replyByMail} id={node.id} />;
  }

  if (type === 'Meeting') {
    return <Meeting {...other} id={node.id} />;
  }

  if (type === 'YcCall') {
    if (maxAccess !== undefined && !Access.isEdit(maxAccess)) {
      other.access = READONLY_YCCALL_ACCESS;
    }
    // @ts-ignore
    return <Call {...other} isOpen={expandItems} id={node.id} />;
  }

  return null;
};

interface ConnectedState {
  node: {
    id: number;
  };
  type: string;
}

interface ConnectedProps {
  nodeId: string;
  issueId: number;
}

export default withReduxContext(
  connect<ConnectedState, {}, ConnectedProps & InjectedReduxContextProps>(
    (state, props) =>
      (({
        node: props.redux.selectors.storage.nodes.getItem(
          state,
          `issues.${props.issueId}.timeline`,
          props.nodeId,
        ),
        type: String(props.nodeId).split(':')[0],
      } as unknown) as ConnectedState),
  )(TimelineNode),
);
